<?php

namespace app\models;

use Yii;
use yii\base\Model;
use app\models\User;
use app\models\Role;

class TerminalForm extends Model
{
    const TERMINAL_CODE_PREFIX = 'M';

    public $code;
    public $name;
    public $address;
    public $phone_number_one;
    public $password;

    const SCENARIO_ADD = 'scenario_add';

    public function rules()
    {
        return [
            [ ['code', 'name', 'address', 'phone_number_one', 'password'], 'required' ]
        ];
    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_ADD] = ['code', 'name', 'address', 'phone_number_one', 'password'];

        return $scenarios;
    }

    public function init()
    {
        parent::init();
        if( $this->scenario == self::SCENARIO_ADD ) {
            $lastId = Yii::$app->db
            ->createCommand('SELECT MAX(id) AS last_id FROM users')
            ->queryScalar();
            $lastId = (int) $lastId + 1;

            $this->code = self::TERMINAL_CODE_PREFIX . str_pad((string)$lastId, 5, "0", STR_PAD_LEFT);
        }
    }

    public function create()
    {
        $user = new User();
        $user->code = $this->code;
        $user->username = uniqid('tr_');
        $user->password = $this->password;
        $user->name = $this->name;
        $user->role = Role::ROLE_TERMINAL;
        $user->address = $this->address;
        $user->phone_one = $this->phone_number_one;
        $user->created_at = date('Y-m-d H:i:s');

        if($user->save()) {
            Yii::$app->db->createCommand()->insert('terminal_activation_log', [
                'terminal_id' => $user->id
            ])->execute();

            return true;
        }

        return false;
    }

    public function update()
    {
        $user = User::findOne(['code' => $this->code]);
        $user->name = $this->name;
        $user->address = $this->address;
        $user->phone_one = $this->phone_number_one;

        return $user->save();

    }
}