<?php

namespace app\models;

use RuntimeException;
use yii\base\Model;

class BaseSettingsModel extends Model
{
    /**
     * @var \common\models\Setttings $settingsModel
     */
    private $settingsModel;

    /**
     * @var string $settings_name
     */
    protected $settings_name;

    public function init()
    {
        parent::init();

        if(is_null($this->settings_name) || $this->settings_name == '') {
            throw new RuntimeException('please add a settings_name attribute in ' . get_class($this));
        }

        $this->settingsModel = new Settings();
        $currentSettingsData = Settings::findOne(['name' => $this->settings_name]);

        // populate model attribute with settings data if exist
        if($currentSettingsData) {
            $this->settingsModel = $currentSettingsData;
            $settingsValue = $currentSettingsData->value;
            if(is_array($settingsValue)) {
                foreach($settingsValue as $key => $value) {
                    if($this->hasProperty($key)) {
                        $this->$key = $value;
                    }
                }
            }
        }
    }

    /**
     * Save the settings
     * 
     * @return bool
     */
    public function saveSettings()
    {
        $this->settingsModel->name = $this->settings_name;
        $this->settingsModel->value = \serialize($this->getSaveableAttr());
        $this->settingsModel->save();
    }
}