CREATE TABLE users(
    id INT NOT NULL AUTO_INCREMENT,
    code VARCHAR(255) NOT NULL,
    username VARCHAR(255) DEFAULT NULL,
    password VARCHAR(255) DEFAULT NULL,
    auth_key VARCHAR(255) DEFAULT NULL,
    access_token VARCHAR(500) DEFAULT NULL,
    name VARCHAR(500) DEFAULT NULL,
    address TEXT DEFAULT NULL,
    city VARCHAR(50) DEFAULT NULL,
    phone_one VARCHAR(15) DEFAULT NULL,
    phone_two VARCHAR(15) DEFAULT NULL,
    wallet_amount DECIMAL(10,2) DEFAULT 0,
    is_active ENUM("1", "0") DEFAULT "1",
    last_login DATETIME DEFAULT NULL,
    created_at DATETIME DEFAULT CURRENT_TIMESTAMP,

    PRIMARY KEY(id),
    CONSTRAINT uniq_username_users UNIQUE(username),
    CONSTRAINT uniq_access_token_users UNIQUE(access_token)
);

CREATE TABLE stocklist_terminal(
    id INT NOT NULL AUTO_INCREMENT,
    stocklist_id INT DEFAULT NULL,
    terminal_id INT DEFAULT NULL,

    PRIMARY KEY(id),

    CONSTRAINT uniq_stocklist_terminal_stocklist_terminal UNIQUE(stocklist_id, terminal_id),

    CONSTRAINT fk_stocklist_id_stocklist_terminal FOREIGN KEY(stocklist_id) REFERENCES users(id)
        ON DELETE CASCADE
        ON UPDATE NO ACTION,

    CONSTRAINT fk_terminal_id_stocklist_terminal FOREIGN KEY(terminal_id) REFERENCES users(id)
        ON DELETE CASCADE
        ON UPDATE NO ACTION
);

CREATE TABLE settings(
    id INT NOT NULL AUTO_INCREMENT,
    name varchar(255) NOT NULL,
    value LONGTEXT,

    PRIMARY KEY(id)
);

CREATE TABLE terminal_activation_log(
    id INT NOT NULL AUTO_INCREMENT,
    terminal_id INT,
    status VARCHAR(255) DEFAULT NULL,
    last_activation DATETIME,

    PRIMARY KEY(id),
    CONSTRAINT uniq_terminal_id_terminal_activation_log UNIQUE KEY(terminal_id),
    CONSTRAINT fk_terminal_id_terminal_activation_log FOREIGN KEY(terminal_id) REFERENCES users(id)
        ON DELETE CASCADE
        ON UPDATE NO ACTION
);