<?php
/**
 * @link http://www.yiiframework.com/
 * @copyright Copyright (c) 2008 Yii Software LLC
 * @license http://www.yiiframework.com/license/
 */

namespace app\commands;

use Yii;
use yii\console\Controller;
use yii\console\ExitCode;

class RbacController extends Controller
{
    public function actionInit($userTable = 'users')
    {
        $this->actionTableDown($userTable);

        $sql = file_get_contents( __DIR__ . '/rbac/rbac-up.sql');
        $sql = str_replace('<userTable>', $userTable, $sql);

        $this->runQuery($sql);
        echo 'RBAC table migration complete' . PHP_EOL;

        $this->initUserRoles();
        $this->initUserPermissions();
        $this->initSuperUserPremission();
        
        return ExitCode::OK;
    }

    private function initUserRoles()
    {
        $command = Yii::$app->db;

        $roles = [
            'super_admin',
            'stock_list',
            'terminal'
        ];

        echo 'Setting up user roles' . PHP_EOL;
        foreach($roles as $role) {
            $command->createCommand()->insert('roles', [
                'name' => $role
            ])->execute();
        }
        echo 'User roles setup finish' . PHP_EOL;

    }

    private function initUserPermissions()
    {
        echo 'Setting up permissions...' . PHP_EOL;

        $modules = [
            [
                'name' => 'dashboard',
                'permissions' => ['view']
            ],
            [
                'name' => 'roles',
                'permissions' => ['manage']
            ],
            [
                'name' => 'limits',
                'permissions' => ['stocklist', 'terminal']
            ],
            [
                'name' => 'master',
                'permissions' => ['stocklist create', 'stocklist edit', 'terminal create',  'terminal edit', 'assigning', 'list']
            ],
            [
                'name' => 'game settings',
                'permissions' => ['status']
            ],
            [
                'name' => 'reports',
                'permissions' => ['view customer sales', 'stocklist sales', 'today draw', 'barcode', 'result', 'customer balance', 'online terminals', 'stocklist balance']
            ],
            [
                'name' => 'blocks',
                'permissions' => ['stocklist', 'terminal']
            ],
            [
                'name' => 'settings',
                'permissions' => ['change password', 'payout settings', 'game message', 'terminal activation', 'desktop password', 'software updation', 'manual result time']
            ]
        ];

        foreach($modules as $module) {
            $moduleName = $module['name'];

            $db = Yii::$app->db;

            // insert module
            $db->createCommand()->insert('modules', [
                'name' => $moduleName
            ])->execute();

            $module_id = $db->getLastInsertID();

            // insert module permissions
            foreach( $module['permissions'] as $perm ) {
                $db->createCommand()->insert('permissions', [
                    'module_id' => $module_id,
                    'name' => $perm
                ])->execute();
            }
        }

        echo 'permission setup finish...' . PHP_EOL;
    }

    private function initSuperUserPremission()
    {
        echo 'Setting up super user permissions...' . PHP_EOL;

        $sql = "SELECT id FROM roles WHERE name = 'super_admin'";
        $role_id = Yii::$app->db->createCommand($sql)->queryScalar();

        // get all permissions form permission table
        $currentPerms = Yii::$app->db->createCommand("SELECT * FROM permissions")->queryAll();
        foreach($currentPerms as $perm) {
            Yii::$app->db->createCommand()->insert('role_permissions', [
                'role_id' => $role_id,
                'permission_id' => $perm['id']
            ])->execute();
        }

        echo 'Super user permissions finish...' . PHP_EOL;
    }

    public function actionTableDown($userTable = 'users')
    {
        $sql = file_get_contents( __DIR__ . '/rbac/rbac-down.sql');
        $sql = str_replace('<userTable>', $userTable, $sql);

        $this->runQuery($sql);
        echo 'RBAC table down complete' . PHP_EOL;

        return ExitCode::OK;
    }

    private function runQuery($sql)
    {
        $command = Yii::$app->db->createCommand($sql);
        $command->execute();

        // Make sure, we fetch all errors
        while ($command->pdoStatement->nextRowSet()) {}
    }
}