<?php

namespace app\models\settings;

use app\models\BaseSettingsModel;

class GameMessageSettings extends BaseSettingsModel
{
    protected $settings_name = 'game-message-settings';

    public $message;

    public function rules()
    {
        return [
            [ 'message', 'required']
        ];
    }

    public function init()
    {
        parent::init();
        if(!$this->message) {
            $this->message = 'Welcome To Bigstar*** Thank you ***';
        }
    }

    public function getSaveableAttr()
    {
        return [
            'message' => $this->message
        ];
    }
}