<?php

namespace app\models;

use Yii;
use app\models\Role;

class Report
{
    public static function getAllStockListBalance()
    {
        $sql = "SELECT u.code, u.name, u.wallet_amount
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        WHERE r.name = :roleName";

        return Yii::$app->db->createCommand($sql, [':roleName' => Role::ROLE_STOCK_LIST])->queryAll();
    }

    public static function getAllActiveTerminals()
    {
        if (Yii::$app->session->get('role') == Role::ROLE_STOCK_LIST) {
            $userId =  Yii::$app->user->id;
            $terminal_id_array = Yii::$app->db->createCommand("SELECT terminal_id FROM stocklist_terminal WHERE stocklist_id=$userId")->queryAll();
            $terminal_id_array = array_column($terminal_id_array, 'terminal_id');
            $terminal_id_array = join(',', $terminal_id_array);
            $sql = "SELECT u.code, u.name, u.last_login, (
                SELECT IFNULL(SUM(orders.grand_total), 0) FROM orders WHERE orders.terminal_id = u.id AND DATE(orders.created_at) = CURDATE()
            ) AS total_bid_amount
            FROM users AS u
            INNER JOIN terminal_activation_log AS t_l ON t_l.terminal_id = u.id
            INNER JOIN roles AS r ON r.id = u.role_id
            WHERE u.id IN ($terminal_id_array) AND r.name = :roleName AND t_l.status = :status
            HAVING total_bid_amount > 0";
        } else {
            $sql = "SELECT u.code, u.name, u.last_login, (
                SELECT IFNULL(SUM(orders.grand_total), 0) FROM orders WHERE orders.terminal_id = u.id AND DATE(orders.created_at) = CURDATE()
            ) AS total_bid_amount
            FROM users AS u
            INNER JOIN terminal_activation_log AS t_l ON t_l.terminal_id = u.id
            INNER JOIN roles AS r ON r.id = u.role_id
            WHERE r.name = :roleName AND t_l.status = :status
            HAVING total_bid_amount > 0";
        }
        return Yii::$app->db->createCommand($sql, [':roleName' => Role::ROLE_TERMINAL, ':status' => 'Activated'])->queryAll();
    }

    public static function getAllTerminalBalance()
    {
        if (Yii::$app->session->get('role') == Role::ROLE_STOCK_LIST) {
            $userId =  Yii::$app->user->id;
            $terminal_id_array = Yii::$app->db->createCommand("SELECT terminal_id FROM stocklist_terminal WHERE stocklist_id=$userId")->queryAll();
            $terminal_id_array = array_column($terminal_id_array, 'terminal_id');
            $terminal_id_array = join(',', $terminal_id_array);
            $sql = "SELECT u.code, u.name, u.wallet_amount
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        WHERE u.id IN ($terminal_id_array) AND r.name = :roleName";
        } else {
            $sql = "SELECT u.code, u.name, u.wallet_amount
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        WHERE r.name = :roleName";
        }
        return Yii::$app->db->createCommand($sql, [':roleName' => Role::ROLE_TERMINAL])->queryAll();
    }

    public static function getTodayDrawWiseReport()
    {
        $db = Yii::$app->db;

        $sql = "SELECT * FROM settings WHERE name = :name";
        $settingsData = $db->createCommand($sql, [':name' => 'payout-settings'])->queryOne();
        $settingsValue = unserialize($settingsData['value']);

        $sql = "SELECT
            r.number AS result,
            r.session_id AS session,
            r.payout_server,
            (
                SELECT 
                    IFNULL(SUM(orders.grand_total), 0) 
                FROM orders
                WHERE orders.session_id = r.session_id AND orders.is_canceled = 0
            ) AS amount_sales,
            (
                SELECT
                    IFNULL(SUM(orders.ticket_winning_amt), 0) 
                FROM orders
                INNER JOIN order_items ON order_items.order_id = orders.id
                WHERE 
                    1
                    AND orders.session_id = r.session_id
                    AND orders.is_canceled = 0
                    AND order_items.number = r.number
            ) AS prize,
            CASE
                WHEN r.result_multiple IS NULL OR r.result_multiple = 0 THEN 0
                ELSE r.result_multiple
            END AS result_multiple
        FROM results AS r
        WHERE r.published_on >= CURDATE() AND r.published_on < DATE_ADD(CURDATE(), INTERVAL 1 DAY)";

        $data = $db->createCommand($sql)->queryAll();

        $counter = 0;
        foreach ($data as &$report) {
            $report['sl_no'] = $counter++;
            $report['game_name'] = $settingsValue['game_name'];
            $report['result'] = str_pad($report['result'], 2, '0', STR_PAD_LEFT);
            
            $dateTime = new \DateTime();
            $dateTime->setTimestamp(intval($report['session']));

            $report['draw_time'] = $dateTime->format('h:i A');
            $report['mrp'] = $settingsValue['mrp'];

            if (floatval($report['amount_sales']) == 0) {
                $report['payout_on_sales'] = 0;
            } else {
                $report['payout_on_sales'] = round((floatval($report['prize']) / floatval($report['amount_sales'])) * 100, 2);
                // $report['payout_on_sales'] = round((floatval($report['amount_sales']) / floatval($report['prize'])) * 100, 2);
            }
        }
        
        return $data;
    }

    public static function getStocklistSummry($from_date, $to_date)
    {
        if (empty($from_date) || empty($to_date)) {
            return [
                'reports' => [],
                'aggregrate_data' => []
            ];
        }

        $db = Yii::$app->db;

        // find all stocklist user
        $sql = "SELECT u.id, u.name
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        WHERE r.name = :roleName";

        $stocklistUser = $db->createCommand($sql, [':roleName' => Role::ROLE_STOCK_LIST])->queryAll();

        $data = [];
        foreach ($stocklistUser as $user) {

            // find all terminal
            $sql = "SELECT
                IFNULL(SUM(o.total_quantity),
                0) AS quantity,
                IFNULL(SUM(o.grand_total),
                0) AS amount,
                IFNULL(
                    SUM(
                        o.grand_total * 0.01 * (
                            IFNULL(
                                (
                                SELECT
                                    rate
                                FROM
                                    terminal_daily_commission_rate
                                WHERE
                                    terminal_id = u.id AND play_date = DATE(o.created_at)
                            ),
                            6
                            )
                        )
                    ),
                    0
                ) AS commission_value
            FROM
                orders AS o
            INNER JOIN users AS u
            ON
                u.id = o.terminal_id
            WHERE
                u.id IN (
                SELECT
                    terminal_id
                FROM
                    stocklist_terminal
                WHERE
                    stocklist_id = :stocklist_id
            ) AND DATE(o.created_at) BETWEEN :from_date AND :to_date AND o.is_canceled = 0";

            $terminalData = $db->createCommand($sql, [
                ':stocklist_id' => $user['id'],
                ':from_date' => $from_date,
                ':to_date' => $to_date
            ])->queryOne();

            // now find prize
            $sql = "SELECT 
                IFNULL(SUM(o.ticket_winning_amt), 0 ) AS prize 
            FROM orders AS o 
            WHERE o.terminal_id IN (
                SELECT
                    terminal_id
                FROM
                    stocklist_terminal
                WHERE
                    stocklist_id = :stocklist_id
            )
            AND o.is_claimed = 'yes' 
            AND o.claimed_on BETWEEN '$from_date' AND '$to_date'";

            $result = $db->createCommand($sql, [':stocklist_id' => $user['id']])->queryOne();

            $terminalData['prize'] = $result['prize'];

            $total = floatval($terminalData['amount']) - floatval($terminalData['prize']);
            $commission_value = round($terminalData['commission_value'], 2);

            if (intval($terminalData['amount']) > 0) {
                $data[] = [
                    'name' => $user['name'],
                    'quantity' => $terminalData['quantity'],
                    'amount' => $terminalData['amount'],
                    'prize' => $terminalData['prize'],
                    'total' => $total,
                    'commission_value' => $commission_value,
                    'net_payable' => $total - $commission_value
                ];
            }
        }

        return [
            'reports' => $data,
            'aggregrate_data' => [
                'total_quantity' => array_sum(array_column($data, 'quantity')),
                'total_amount' => array_sum(array_column($data, 'amount')),
                'total_prize' => array_sum(array_column($data, 'prize')),
                'total_total' => array_sum(array_column($data, 'total')),
                'total_commission_value' => array_sum(array_column($data, 'commission_value')),
                'total_net_payable' => array_sum(array_column($data, 'net_payable'))
            ]
        ];
    }

    public static function getGameResultByDate($date)
    {
    }
}