<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

use app\models\User;
use app\models\Role;

class UserController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['get-user-info'],
                'rules' => [
                    [
                        'actions' => ['get-user-info'],
                        'allow' => true,
                        'roles' => ['@']
                    ],
                ]
            ]
        ];
    }

    public function actionGetUserInfo()
    {
        $id = $this->request->get('id');

        if(is_null($id) || empty($id)) {
            header('Content-Type: application/json');
            return json_encode([]);
            die;
        }

        $user = User::findOne($id);
        $userData = $user->toArray([
            'code', 'original_password', 'username', 'name', 'address', 'city', 'phone_one', 'phone_two', 'wallet_amount',
            'commission_rate'
        ]);

        if($user->role->name == Role::ROLE_TERMINAL) {
            // find stocklist info
            $sql = "SELECT 
                users.id, 
                users.code, 
                users.username, 
                users.name 
            FROM users
            INNER JOIN stocklist_terminal ON stocklist_terminal.stocklist_id = users.id
            WHERE stocklist_terminal.terminal_id =:terminal_id";

            $stocklist = Yii::$app->db->createCommand($sql)
            ->bindValue(':terminal_id', $user->id)
            ->queryOne();

            $userData['terminal_info'] = [
                'stocklist' =>  $stocklist
            ];
        }

        header('Content-Type: application/json');
        echo json_encode($userData);
        die;
    }
}