<?php

namespace app\controllers;

use app\models\Role;
use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

class RoleController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['index', 'perms'],
                'rules' => [
                    [
                        'actions' => ['index', 'perms'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            return  Yii::$app->user->can('manage roles');
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionIndex()
    {
        $sql = "SELECT * FROM roles WHERE name <> 'terminal'";
        return $this->render('index', [
            'roles' => Yii::$app->db->createCommand($sql)->queryAll()
        ]);
    }

    public function actionPerms($role_id)
    {   
        if($this->request->isPost) {
            $role = Role::findOne(['id' => $role_id]);
            
            if($role->name == Role::ROLE_SUPER_ADMIN) {
                Yii::$app->session->setFlash('error', 'Super user permissions can not be changed');
                return $this->redirect(['role/index']);
            }

            if(isset($_POST['permissions'])) {
                // remove old permissions from this role
                $db = Yii::$app->db;
                $db->createCommand("DELETE FROM role_permissions WHERE role_id = :role_id", [':role_id' => $role_id])->execute();
                foreach($_POST['permissions'] as $perm) {
                    $db->createCommand()->insert('role_permissions', [
                        'role_id' => $role_id,
                        'permission_id' => $perm
                    ])->execute();
                }
            }

            Yii::$app->session->setFlash('success', 'Permission updated successfully');
            return $this->redirect(['role/index']);
        }

        return $this->render('perms', [
            'currentPermsIds' => Role::getPermissionIds($role_id),
            'modulePerms' => Role::getAllModulePermissions()
        ]);
    }
}