<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

use app\models\LoginForm;
use app\models\ChangePasswordForm;

class AuthController extends Controller 
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['logout', 'change-password'],
                'rules' => [
                    [
                        'actions' => ['logout', 'change-password'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if($action->id == 'change-password') {
                                return Yii::$app->user->can('change password settings');
                            } else if($action->id == 'logout') {
                                return true;
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionLogin()
    {
        $this->layout = 'auth';
        $model = new LoginForm();

        if($this->request->isPost) {
            if( $model->load($this->request->post()) && $model->validate() ) {
                if($model->login()) {
                    return $this->redirect(['/']);
                }
            }
        }

        return $this->render('login', [
            'model' => $model
        ]);
    }

    public function actionLogout()
    {
        Yii::$app->user->logout();

        return $this->redirect(['auth/login']);
    }

    public function actionChangePassword()
    {
        $model = new ChangePasswordForm();

        if( $model->load($this->request->post()) && $model->validate() ) {
            if($model->updatePassword()) {
                Yii::$app->session->setFlash('success', 'Password changed successfully');
                return $this->redirect(['/dashboard']);
            }
        } else {
            $model->current_password = '';
            $model->new_password = '';
            $model->confirm_password = '';
        }

        return $this->render('change-password', [
            'model' => $model
        ]);
    }
}