<?php

use app\models\Role;

$params = require __DIR__ . '/params.php';
$db = require __DIR__ . '/db.php';

$config = [
    'id' => '2star-game',
    'basePath' => dirname(__DIR__),
    'bootstrap' => ['log'],
    'timeZone' => 'Asia/Calcutta',
    'aliases' => [
        '@bower' => '@vendor/bower-asset',
        '@npm'   => '@vendor/npm-asset',
    ],
    'defaultRoute' => 'dashboard',
    'components' => [
        'request' => [
            // !!! insert a secret key in the following (if it is empty) - this is required by cookie validation
            'cookieValidationKey' => 'diy__ec6VTity_vuGjLerwE0JELHXkgo',
        ],
        'cache' => [
            'class' => 'yii\caching\FileCache',
        ],
        'user' => [
            'identityClass' => 'app\models\User',
            'enableAutoLogin' => false,
            'authTimeout' => 30 * 60,
            'loginUrl' => ['auth/login'],
            'accessChecker' => '\app\components\PermissionAccessCheck',
            'on beforeLogin' => function ($event) {
                $user = $event->identity;
                $role_id =  $user->role_id;

                $session = Yii::$app->session;
                if (!is_null($role_id)) {
                    $roleInfo = Role::findOne(['id' => $role_id]);
                    $rolePerms = Role::getPermissions($role_id);

                    $session->set('role', $roleInfo->name);
                    $session->set('permissions', $rolePerms);
                } else {
                    $session->set('role', null);
                    $session->set('permissions', []);
                }
            },
            'on afterLogin' => function ($event) {
                $user = $event->identity;
                Yii::$app->db->createCommand()->update('users', ['last_login' => date('Y-m-d H:i:s')], ['id' => $user->id])->execute();
            }
        ],
        'errorHandler' => [
            'errorAction' => 'site/error',
        ],
        'mailer' => [
            'class' => 'yii\swiftmailer\Mailer',
            // send all mails to a file by default. You have to set
            // 'useFileTransport' to false and configure transport
            // for the mailer to send real emails.
            'useFileTransport' => true,
        ],
        'log' => [
            'traceLevel' => YII_DEBUG ? 3 : 0,
            'targets' => [
                [
                    'class' => 'yii\log\FileTarget',
                    'levels' => ['error', 'warning'],
                ],
            ],
        ],
        'db' => $db,
        'urlManager' => [
            'enablePrettyUrl' => true,
            'showScriptName' => false,
            'rules' => [],
        ],
        'view' => [
            'theme' => [
                'basePath' => '@app/themes/bigstar',
                'baseUrl' => '@web/themes/bigstar',
                'pathMap' => [
                    '@app/views' => '@app/themes/bigstar',
                ],
            ],
            'as ThemeContentBehavior' => [
                'class' => \app\components\ThemeContentBehavior::class
            ]
        ],
        'formatter' => [
            'currencyCode' => 'INR'
        ]
    ],
    'params' => $params,
];

if (YII_ENV_DEV) {
    // configuration adjustments for 'dev' environment
    $config['bootstrap'][] = 'debug';
    $config['modules']['debug'] = [
        'class' => 'yii\debug\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];

    $config['bootstrap'][] = 'gii';
    $config['modules']['gii'] = [
        'class' => 'yii\gii\Module',
        // uncomment the following to add your IP if you are not connecting from localhost.
        //'allowedIPs' => ['127.0.0.1', '::1'],
    ];
}

return $config;
