<?php

namespace app\components;

use Yii;
use yii\base\Behavior;
use yii\base\View;

class ThemeContentBehavior extends Behavior
{
    public function init()
    {
        parent::init();
    }

    public function events()
    {
        return [
            View::EVENT_BEGIN_PAGE => [$this, 'handleBeforeRender']
        ];
    }

    public function handleBeforeRender($event)
    {
        $view = $this->owner;
        $title =  ucfirst(Yii::$app->controller->action->controller->id) . ' | ' . ucfirst(Yii::$app->controller->action->id);
        $view->title = $title;
    }
}