<?php

namespace app\models\settings;

use app\models\BaseSettingsModel;

class GameStateSettings extends BaseSettingsModel
{
    protected $settings_name = 'game-state-settings';

    public $state;

    public function init()
    {
        parent::init();
        if(!$this->state) {
            $this->state = 'enable';
        }
    }

    public function getSaveableAttr()
    {
        return [
            'state' => ($this->state == 'enable') ? 'disable' : 'enable'
        ];
    }
}