<?php

use yii\db\Migration;

/**
 * Class m220816_111938_final
 */
class m220816_111938_final extends Migration
{
    /**
     * {@inheritdoc}
     */
    public function safeUp()
    {
        $sql = file_get_contents(__DIR__ . '/db-up.sql');
        $command = Yii::$app->db->createCommand($sql);
        $command->execute();

        // Make sure, we fetch all errors
        while ($command->pdoStatement->nextRowSet()) {}

        // insert super admin user
        $this->insert('users', [
            'code' => 'ST00001',
            'username' => 'admin',
            'password' => md5('admin'),
            'name' => "Json Brody",
            'city' => 'P.L Beach',
            'auth_key' => uniqid(),
            'is_active' => '1',
            'created_at' => date('Y-m-d H:i:s')
        ]);
    }

    /**
     * {@inheritdoc}
     */
    public function safeDown()
    {
        $this->delete('users', ['username' => 'admin'] );

        $sql = file_get_contents(__DIR__ . '/db-down.sql');
        $command = Yii::$app->db->createCommand($sql);
        $command->execute();

        // Make sure, we fetch all errors
        while ($command->pdoStatement->nextRowSet()) {}
    }

    /*
    // Use up()/down() to run migration code without a transaction.
    public function up()
    {

    }

    public function down()
    {
        echo "m220816_111938_final cannot be reverted.\n";

        return false;
    }
    */
}
