<?php

namespace app\controllers;

use Yii;
use app\models\Role;
use yii\web\Controller;
use yii\filters\AccessControl;

use app\models\User;
use app\models\TerminalForm;
use app\models\Terminal;
use app\models\AssignStocklistTerminalForm;

class TerminalController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['create', 'update', 'assign', 'wallet-info', 'activation'],
                'rules' => [
                    [
                        'actions' => ['create', 'update', 'assign', 'wallet-info', 'activation'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if ($action->id == 'create') {
                                return Yii::$app->user->can('terminal create master');
                            } else if ($action->id == 'update') {
                                return Yii::$app->user->can('terminal edit master');
                            } else if ($action->id == 'assign') {
                                return Yii::$app->user->can('assigning master');
                            } else if ($action->id == 'activation') {
                                return Yii::$app->user->can('terminal activation settings');
                            } else if ($action->id == 'desktop-password') {
                                return Yii::$app->user->can('desktop password settings');
                            } else {
                                return true;
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionDesktopPassword()
    {
        $terminalDesktopPassword = null;
        if ($this->request->isPost) {
            $user = User::findOne($this->request->post('terminal_id'));
            if ($user) {
                $password = strtoupper(uniqid());
                $user->desktop_quit_password = md5($password);
                $user->save(false);
                $terminalDesktopPassword = $password;

                Yii::$app->session->setFlash('success', 'Desktop password generated successfully');
            }
        }

        return $this->render('desktop-password', [
            'terminalUsers' => User::getAllTerminalUsers(),
            'terminalDesktopPassword' => $terminalDesktopPassword
        ]);
    }

    public function actionCreate()
    {
        $model = new TerminalForm(['scenario' =>  TerminalForm::SCENARIO_ADD]);

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->validate()) {
                if ($model->create()) {
                    Yii::$app->session->setFlash('success', 'Terminal created successfully');
                    return $this->redirect(['dashboard/index']);
                }
            }
        }

        return $this->render('create', [
            'model' => $model
        ]);
    }

    public function actionUpdate()
    {
        $model = new TerminalForm(['scenario' =>  TerminalForm::SCENARIO_UPDATE]);

        if ($this->request->isPost) {
     
            if ($model->load($this->request->post()) && $model->validate()) {
                $model->stocklist_id = $this->request->post('stock_user_code');
                if ($model->update()) {
                    Yii::$app->session->setFlash('success', 'Terminal updated successfully');
                    return $this->redirect(['dashboard/index']);
                }
            }
        }

        return $this->render('update', [
            'model' => $model,
            'terminalUsers' => User::getAllTerminalUsers(),
            'stockListUsers' => User::getAllStockListUsers(),
        ]);
    }

    public function actionAssign()
    {
        if ($this->request->isPost) {
            $terminal_id = $this->request->post('terminal_user_code');
            $stocklist_id = $this->request->post('stock_user_code');

            $model = new AssignStocklistTerminalForm();
            $model->terminal_id = $terminal_id;
            $model->stocklist_id = $stocklist_id;

            if ($model->validate() && $model->assign()) {
                Yii::$app->session->setFlash('success', 'Stockist assign successful');
                return $this->redirect(['dashboard/index']);
            } else {
                $errors = $model->getErrorSummary(false);
                Yii::$app->session->setFlash('error', $errors[0]);
            }
        }

        return $this->render('assign', [
            'stockListUsers' => User::getAllStockListUsers(),
            'terminalUsers' => User::getAllTerminalUsers()
        ]);
    }

    public function actionWalletInfo()
    {
        $id = $this->request->get('id');
        $walletInfo = Terminal::getWalletInfo($id);

        header('Content-Type: application/json');
        echo json_encode($walletInfo);
        die;
    }

    public function actionActivation()
    {
        $passwordActivated = false;
        $terminalPassword = '';
        if ($this->request->isPost) {
            $terminal_id = $this->request->post('terminal_id');
            $status = $this->request->post('status');

            if (empty($terminal_id)) {
                Yii::$app->session->setFlash('error', 'Please select a terminal');
                return $this->redirect('activation');
            }

            if ($status == 'active') {
                try {
                    $activeStatus = Terminal::activateTerminal($terminal_id);
                    if ($activeStatus !== false) {
                        $terminalPassword = $activeStatus;
                    }
                    Yii::$app->session->setFlash('success', 'Terminal activated successfully');
                } catch (\Exception $e) {
                    Yii::$app->session->setFlash('error', $e->getMessage());
                    return $this->redirect('activation');
                }
            } else if ($status == 'blocked') {
                try {
                    if (Terminal::blockTerminal($terminal_id)) {
                        Yii::$app->session->setFlash('success', 'Terminal blocked successfully');
                    }
                } catch (\Exception $e) {
                    Yii::$app->session->setFlash('error', $e->getMessage());
                    return $this->redirect('activation');
                }
            }
        }
        if (Yii::$app->session->get('role') == Role::ROLE_STOCK_LIST) {
            $userId =  Yii::$app->user->id;
            $terminal_id_array = Yii::$app->db->createCommand("SELECT terminal_id FROM stocklist_terminal WHERE stocklist_id=$userId")->queryAll();
            $terminal_id_array = array_column($terminal_id_array, 'terminal_id');
            $terminal_id_array = join(',', $terminal_id_array);
            $sql = "SELECT u.id, u.code, t_l.status, IFNULL(t_l.last_activation, 'N/A') AS last_activation
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        LEFT JOIN terminal_activation_log AS t_l ON t_l.terminal_id = u.id
        WHERE u.id IN ($terminal_id_array) AND r.name = :role_name";
        } else {
            $sql = "SELECT u.id, u.code, t_l.status, IFNULL(t_l.last_activation, 'N/A') AS last_activation
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        LEFT JOIN terminal_activation_log AS t_l ON t_l.terminal_id = u.id
        WHERE r.name = :role_name";
        }

        $terminalUsers = Yii::$app->db->createCommand($sql, [':role_name' => Role::ROLE_TERMINAL])->queryAll();
        return $this->render('activation', [
            'terminalUsers' => $terminalUsers,
            'passwordGenerated' => $passwordActivated,
            'terminalPassword' => $terminalPassword
        ]);
    }
}
