<?php

namespace app\controllers;

use Yii;
use app\models\Role;
use yii\web\Controller;
use yii\filters\AccessControl;
use app\models\StockListForm;
use app\models\User;


class StocklistController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['create', 'update', 'show'],
                'rules' => [
                    [
                        'actions' => ['create', 'update', 'show'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if($action->id == 'create') {
                                return  Yii::$app->user->can('stocklist create master');
                            } else if($action->id == 'update') {
                                return  Yii::$app->user->can('stocklist edit master');
                            } else if($action->id == 'show') {
                                return  Yii::$app->user->can('list master');
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionCreate()
    {
        $model = new StockListForm(['scenario' => StockListForm::SCENARIO_ADD]);

        if($this->request->isPost) {
            if( $model->load($this->request->post()) && $model->validate() ) {
                if($model->create()) {
                    Yii::$app->session->setFlash('success', 'Stocklist created successfully');
                    return $this->redirect(['dashboard/index']);
                }
            }
        }

        return $this->render('create', [
            'model' => $model
        ]);
    }

    public function actionUpdate()
    {
        $model = new StockListForm(['scenario' => StockListForm::SCENARIO_UPDATE]);
        if( $this->request->isPost ) {
            if( $model->load($this->request->post()) && $model->validate() ) {
                if($model->update()) {
                    Yii::$app->session->setFlash('success', 'Stocklist updated successfully');
                    return $this->redirect(['dashboard/index']);
                }
            }
        }

        return $this->render('update', [
            'model' => $model,
            'stocklistsUsers' => User::getAllStockListUsers()
        ]);
    }

    public function actionShow()
    {
        $db = Yii::$app->db;

        // find all stocklist first
        $sql = "SELECT u.id, u.code, u.name, IF(u.is_active = '1', 'Active', 'Blocked') AS status
        FROM users AS u
        INNER JOIN roles AS r ON r.id = u.role_id
        WHERE r.name = :name";

        $stoclistUsers = $db->createCommand($sql, [ ':name' => Role::ROLE_STOCK_LIST ])->queryAll();

        foreach($stoclistUsers as &$user) {
            // get all terminal users for this current stocklist
            $sql = "SELECT 
                u.id,
                u.code,
                u.name,
                CASE
                	WHEN u1.is_active = '0' THEN 'Blocked' -- means stockies is blocked so all terminal will be blocked autometically
                    WHEN u.is_active = '1' THEN 'Active'
                    ELSE 'Blocked'
                END AS status
            FROM users AS u
            INNER JOIN stocklist_terminal AS s_t ON s_t.terminal_id = u.id
            INNER JOIN users AS u1 ON u1.id = :stocklist_id
            WHERE s_t.stocklist_id = :stocklist_id";

            $user['terminal_users'] = $db->createCommand($sql, [ ':stocklist_id' => $user['id'] ])->queryAll();
        }

        return $this->render('show', [
            'stoclistUsers' => $stoclistUsers
        ]);
    }
}