<?php

/* @var $this \yii\web\View */
/* @var $content string */

use app\assets\AppAsset;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="content-type" content="text/html;charset=UTF-8" />
	<title><?= $this->title ?></title>
    <?php $this->registerCsrfMetaTags() ?>
   
    <?php $this->head() ?>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.css" />
    <style type="text/css">
		.style2 {
			font-family: arial;
			font-weight: bold;
			color: #FFFFFF;
		}

		.style3 {
			color: #FF00FF
		}

		strong {
			color: #000;
		}

		.textbox {
			background: none;
			color: #000;
			border: none;
			cursor: default;
			font-family: Arial, Helvetica, sans-serif;
			font-size: 15px;
			text-align: left
		}

		.label {
			background: none;
			color: #000;
			border: none;
			cursor: default;
			font-family: Arial, Helvetica, sans-serif;
			font-size: 15px;
			text-align: left
		}

		table td {
			background: #fff;
			color: #000;
			padding: 10px 3px;
		}
        ._css3m {
            display: none
        }
	</style>
</head>
<body>
	<center>
		<?php $this->beginBody() ?>
		
		<!-- header -->
		<?= $this->render('header') ?>

		<?= $content ?>

		<!-- footer -->
		<?= $this->render('footer') ?>

		<?php $this->endBody() ?>

		<?php if (Yii::$app->session->hasFlash('success')): ?>
			<script>
				$.toast({
					text: '<?= Yii::$app->session->getFlash('success') ?>', // Text that is to be shown in the toast
					heading: 'Success', // Optional heading to be shown on the toast
					icon: 'success', // Type of toast icon
					showHideTransition: 'fade', // fade, slide or plain
					allowToastClose: true, // Boolean value true or false
					hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
					stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
					position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
					textAlign: 'center',  // Text alignment i.e. left, right or center
					loader: true,  // Whether to show loader or not. True by default
					loaderBg: '#9EC600',  // Background color of the toast loader
					beforeShow: function () {}, // will be triggered before the toast is shown
					afterShown: function () {}, // will be triggered after the toat has been shown
					beforeHide: function () {}, // will be triggered before the toast gets hidden
					afterHidden: function () {}  // will be triggered after the toast has been hidden
				});
			</script>
		<?php endif ?>

		<?php if (Yii::$app->session->hasFlash('error')): ?>
			<script>
				$.toast({
					text: '<?= Yii::$app->session->getFlash('error') ?>', // Text that is to be shown in the toast
					heading: 'Error', // Optional heading to be shown on the toast
					icon: 'error', // Type of toast icon
					showHideTransition: 'fade', // fade, slide or plain
					allowToastClose: true, // Boolean value true or false
					hideAfter: 3000, // false to make it sticky or number representing the miliseconds as time after which toast needs to be hidden
					stack: 5, // false if there should be only one toast at a time or a number representing the maximum number of toasts to be shown at a time
					position: 'top-center', // bottom-left or bottom-right or bottom-center or top-left or top-right or top-center or mid-center or an object representing the left, right, top, bottom values
					textAlign: 'center',  // Text alignment i.e. left, right or center
					loader: true,  // Whether to show loader or not. True by default
					loaderBg: '#9EC600',  // Background color of the toast loader
					beforeShow: function () {}, // will be triggered before the toast is shown
					afterShown: function () {}, // will be triggered after the toat has been shown
					beforeHide: function () {}, // will be triggered before the toast gets hidden
					afterHidden: function () {}  // will be triggered after the toast has been hidden
				});
			</script>
		<?php endif ?>
	</center>
	<script  defer src="https://cdnjs.cloudflare.com/ajax/libs/jquery-modal/0.9.1/jquery.modal.min.js"></script>
</body>
</html>
<?php $this->endPage() ?>