<?php

namespace app\models;

use Yii;

class Terminal extends User
{
    /**
     * Activate a terminal
     * 
     * @param int $terminal_id
     * @throws \Exception
     * @return bool|int
     */
    public static function activateTerminal($terminal_id)
    {
        $terminal = self::findOne($terminal_id);
        if( !$terminal ) {
            throw new \Exception('Terminal not found');
        }
        
        // update activation time and status
        $activationTime = date('Y-m-d H:i:s');
        $terminalActivationPassword = random_int(10000, 99999);

        Yii::$app->db->createCommand()->upsert('terminal_activation_log', [
            'terminal_id' => $terminal_id,
            'activation_password' => md5($terminalActivationPassword),
            'status' => 'Activated',
            'last_activation' => $activationTime
        ], [ 
            'activation_password' => md5($terminalActivationPassword),
            'status' => 'Activated',
            'last_activation' => $activationTime
        ])->execute();

        return $terminalActivationPassword;
    }

    public static function blockTerminal($terminal_id)
    {
        $terminal = self::findOne($terminal_id);
        if( !$terminal ) {
            throw new \Exception('Terminal not found');
        }

        // update activation status
        Yii::$app->db->createCommand()->update('terminal_activation_log', [
            'activation_password' => NULL,
            'status' => 'Blocked',
            'last_activation' => NULL,
            'is_verifed_from_terminal' => 'no'
        ], [ 'terminal_id' => $terminal_id ])->execute();

        return true;
    }

    /**
     * Get terminal wallet info
     * 
     * @param int $terminal_id
     * @return array
     */
    public static function getWalletInfo($terminal_id)
    {
        $sql = "SELECT wallet_amount AS terminal_wallet_amount, IFNULL(( 
            SELECT u.wallet_amount 
            FROM users AS u
            INNER JOIN stocklist_terminal AS s_t ON s_t.stocklist_id = u.id
            WHERE s_t.terminal_id = :terminal_id LIMIT 1
        ), '') AS stocklist_wallet_amount
        FROM users WHERE id = :terminal_id";

        $data = Yii::$app->db->createCommand($sql, [ ':terminal_id' => $terminal_id ])->queryOne();

        return $data;
    }
}