<?php

namespace app\controllers;

use yii\web\Controller;
use yii\filters\AccessControl;

use app\models\User;

class UserController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['get-user-info'],
                'rules' => [
                    [
                        'actions' => ['get-user-info'],
                        'allow' => true,
                        'roles' => ['@']
                    ],
                ]
            ]
        ];
    }


    public function actionGetUserInfo()
    {
        $id = $this->request->get('id');

        $user = User::findOne($id);
        header('Content-Type: application/json');
        echo json_encode($user->toArray([
            'code', 'username', 'name', 'address', 'city', 'phone_one', 'phone_two', 'wallet_amount'
        ]));
        die;
    }
}