<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

use app\models\settings\PayoutSettings;
use app\models\settings\GameMessageSettings;
use app\models\settings\GameStateSettings;
use app\models\settings\ManualResultTimeSettings;

class SettingsController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['payouts', 'game-message', 'game-state'],
                'rules' => [
                    [
                        'actions' => ['payouts', 'game-message', 'game-state'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if($action->id == 'game-state') {
                                return  Yii::$app->user->can('status game settings');
                            } else if($action->id == 'payouts') {
                                return  Yii::$app->user->can('payout settings settings');
                            } else if($action->id == 'game-message') {
                                return  Yii::$app->user->can('game message settings');
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionPayouts()
    {
        $model = new PayoutSettings();
        if( $this->request->isPost ) {
            if($model->load($this->request->post()) && $model->validate() ) {
                $model->saveSettings();
                Yii::$app->session->setFlash('success', 'Payouts settings saved successfully');
            }
        }

        return $this->render('payouts', [
            'model' => $model
        ]);
    }

    public function actionGameMessage()
    {
        $model = new GameMessageSettings();
        if( $this->request->isPost ) {
            if($model->load($this->request->post()) && $model->validate() ) {
                $model->saveSettings();
                Yii::$app->session->setFlash('success', 'Message settings saved successfully');
            }
        }

        return $this->render('game-message', [
            'model' => $model
        ]);
    }

    public function actionGameState()
    {
        $model = new GameStateSettings();
        $model->saveSettings();
        Yii::$app->session->setFlash('success', 'Game status - ' . $model->state);

        return $this->redirect(['/']);
    }

    public function actionManualResult()
    {
        $db = Yii::$app->db;

        if($this->request->isPost) {
            $result = $this->request->post('result');

            if( $result != '' ) {
                $result = intval($result);
                if( $result >=1 || $result <=99  ) {
                    
                    // all ok publish the result for current session
                    $result_current_session_id = Yii::$app->session->get('result_current_session_id');

                    if( !is_null($result_current_session_id) ) {
                        $db->createCommand()->update('session', [
                            'current_session_result' => $result
                        ], [
                            'current_session_id' => $result_current_session_id
                        ])->execute();
                        
                        Yii::$app->session->setFlash('success', 'Result published successfully');
                    } else {
                        Yii::$app->session->setFlash('error', 'Sorry! Game is closed');
                    }

                    return $this->redirect(['dashboard/index']);
                   
                } else {
                    Yii::$app->session->setFlash('error', 'Result must be between 1 and 99');
                }
            } else {
                Yii::$app->session->setFlash('error', 'Result can not be empty');
            }
        }
        
        date_default_timezone_set('Asia/Kolkata');
        
        $now = new \DateTime();
        $start = new \DateTime(date('Y-m-d') . '09:00:01');
        $end = new \DateTime(date('Y-m-d') . '22:00:01');
            
        if(($now > $start) && ($now < $end)) {
            $sessionInfo = $db->createCommand("SELECT * FROM session")->queryOne();

            $currentSessionId = $sessionInfo['current_session_id'];
    
            $dateTime = new \DateTime();
            $dateTime->setTimestamp( intval($currentSessionId) );
    
            // add the current session id to user current session
            Yii::$app->session->set('result_current_session_id', $currentSessionId);
            
            $result_time = $dateTime->format('h:i A');
        } else {
            Yii::$app->session->remove('result_current_session_id');
            $result_time = '';
        }
       
        return $this->render('manual-result', [
            'result_time' => $result_time
        ]);
    }
    


    public function actionManualResultTime()
    {
        $model = new ManualResultTimeSettings();

        if($this->request->isPost) {
            if($model->load($this->request->post()) && $model->validate() ) {
                $model->saveSettings();
                Yii::$app->session->setFlash('success', 'Message settings saved successfully');
            } else {
                Yii::$app->session->setFlash('error', $model->getFirstError('time_limit'));
            }
        }

        return $this->render('manual-result-time', [
            'model' => $model
        ]);
    }
}