<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

use app\models\User;

class LimitController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['stocklist', 'terminal'],
                'rules' => [
                    [
                        'actions' => ['stocklist', 'terminal'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if ($action->id == 'stocklist') {
                                return Yii::$app->user->can('stocklist limits');
                            } else if ($action->id == 'terminal') {
                                return Yii::$app->user->can('terminal limits');
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionTerminal()
    {
        if ($this->request->isPost) {
            $amt = $this->request->post('amt');
            $terminal_user_id = $this->request->post('terminal_user_id');

            if (empty($amt)) {
                Yii::$app->session->setFlash('error', 'Please enter an amount');
            } else if (empty($terminal_user_id)) {
                Yii::$app->session->setFlash('error', 'Please select a terminal');
            } else {
                try {
                    $user = User::findOne($terminal_user_id);
                    if ($user->updateWalletAmountForTerminal($amt)) {
                        Yii::$app->session->setFlash('success', 'Amount updated successfully');
                    }
                } catch( \Exception $e ) {
                    Yii::$app->session->setFlash('error', $e->getMessage());
                }
            }
        }

        return $this->render('terminal', [
            'terminalUsers' => User::getAllTerminalUsers()
        ]);
    }

    public function actionStocklist()
    {
        if ($this->request->isPost) {
            $amt = $this->request->post('amt');
            $stock_list_user_id = $this->request->post('stock_list_user_id');

            if (empty($amt)) {
                Yii::$app->session->setFlash('error', 'Please enter an amount');
            } elseif (empty($stock_list_user_id)) {
                Yii::$app->session->setFlash('error', 'Please enter a stocklist');
            } else {
                $user = User::findOne($stock_list_user_id);
                if ($user->updateWalletAmountForStocklist($amt)) {
                    Yii::$app->session->setFlash('success', 'Amount updated successfully');
                }
            }
        }

        return $this->render('stocklist', [
            'stockListUsers' => User::getAllStockListUsers()
        ]);
    }
}
