<?php

namespace app\controllers;

use Yii;
use yii\web\Controller;
use yii\filters\AccessControl;

class DashboardController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'access' => [
                'class' => AccessControl::class,
                'only' => ['index'],
                'rules' => [
                    [
                        'actions' => ['index'],
                        'allow' => true,
                        'roles' => ['@'],
                        'matchCallback' => function ($rule, $action) {
                            if ($action->id == 'index') {
                                return  Yii::$app->user->can('view dashboard');
                            }
                        }
                    ],
                ],
            ]
        ];
    }

    public function actionIndex()
    {
        /* echo '<pre>';
        print_r(Yii::$app->session->get('permissions'));
        die; */
        return $this->render('index');
    }
}
